
#include "c4d_resource.h"
#include "c4d_gui.h"

#ifndef __API_INTERN__
#include "c4d_memory.h"
#include "c4d_file.h"
#include "lib_description.h"

Bool RegisterDescription(LONG id, const String &idstr, LocalResource *res)
{
	return Description_Register(id,idstr,res?res:resource.Get());
}
#else

#include "lib_description.h"

Bool RegisterDescription(LONG id, const String &idstr, LocalResource *res)
{
	return Description_Register(id,idstr,NULL);
}

#include "operatingsystem.h"
#endif

GeResource::GeResource(void)
{
	lr     = NULL;
	state  = FALSE;
	initfn = NULL;
	glob   = FALSE;
}

GeResource::~GeResource(void)
{
	Free();
}

void GeResource::Free(void)
{
	if (glob) return;
	if (lr) { C4DOS.Lr->Free(lr); lr=NULL; }
	if (initfn) { gDelete(initfn); }
}

Bool GeResource::Init(void)
{
#ifndef __API_INTERN__
	return Init(GeGetPluginPath());
#else
	return Init(GeGetStartupPath());
#endif
}

Bool GeResource::Init(const Filename &path)
{
	if (!initfn)
	{
		initfn = gNew Filename(path);
		if (!initfn) return FALSE;
	}
	if (state) return lr!=NULL;
	lr = C4DOS.Lr->Alloc((Filename*)&path);
	state=TRUE;
	return lr!=NULL;
}

Bool GeResource::InitAsGlobal(void)
{
	glob=TRUE;
	lr=C4DOS.Lr->GetCinemaResource();
	return lr!=NULL;
}

Bool GeResource::Flush(void)
{
	if (glob) return TRUE;
	if (!initfn) return FALSE;
	C4DOS.Lr->Free(lr);
	lr    = NULL;
	state = FALSE;
	return Init(*initfn);
}

const String &GeResource::LoadString(LONG id)
{
#ifndef __API_INTERN__
	if (!lr) return *C4DOS.St->Default;
	return C4DOS.Lr->LoadString(lr,id);
#else
	return GeLoadString(id);
#endif
}

#ifndef __API_INTERN__
GeResource resource;

void FreeResource()
{
	resource.Free();
}

const String &GeLoadString(LONG id)
{
	return resource.LoadString(id);
}

String GeLoadString(LONG id, const String &p1)
{
	LONG pos;
	String str=resource.LoadString(id);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p1);
	return str;
}

String GeLoadString(LONG id, const String &p1, const String &p2)
{
	LONG pos;
	String str=resource.LoadString(id);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p1);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p2);
	return str;
}

String GeLoadString(LONG id, const String &p1, const String &p2, const String &p3)
{
	LONG pos;
	String str=resource.LoadString(id);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p1);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p2);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p3);
	return str;
}

String GeLoadString(LONG id, const String &p1, const String &p2, const String &p3,const String &p4)
{
	LONG pos;
	String str=resource.LoadString(id);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p1);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p2);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p3);
	if (!str.FindFirst("#",&pos)) return String();
	str.Delete(pos,1);
	str.Insert(pos,p4);
	return str;
}
#endif
